{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 13.08.98 - 21:15:56 $                                        =}
{========================================================================}
unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMDIBCv, MMLevel, MMCCon, MMDSCon, MMDSMix, MMWave,
  MMDSPObj, MMDSCptr, MMCstDlg, MMHook, MMDesign, ExtCtrls;

type
  TForm1 = class(TForm)
    MMDSCapture1: TMMDSCapture;
    MMDSCaptureChannel1: TMMDSCaptureChannel;
    MMDSChannelConnector1: TMMDSChannelConnector;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    FormatBtn: TButton;
    StartBtn: TButton;
    StopBtn: TButton;
    SaveBtn: TButton;
    MMWaveSaveDialog1: TMMWaveSaveDialog;
    MMDesigner1: TMMDesigner;
    Timer1: TTimer;
    Label1: TLabel;
    procedure FormatBtnClick(Sender: TObject);
    procedure StartBtnClick(Sender: TObject);
    procedure MMDSCaptureChannel1CaptureStop(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormatBtnClick(Sender: TObject);
begin
  MMDSCaptureChannel1.SelectFormat;
end;

procedure TForm1.StartBtnClick(Sender: TObject);
begin
  MMDSCaptureChannel1.Capture;
  StopBtn.Enabled := True;
  StartBtn.Enabled := False;
  FormatBtn.Enabled := False;
  SaveBtn.Enabled := False;
end;

procedure TForm1.StopBtnClick(Sender: TObject);
begin
  MMDSCaptureChannel1.Stop;
end;

procedure TForm1.MMDSCaptureChannel1CaptureStop(Sender: TObject);
begin
  StopBtn.Enabled := not True;
  StartBtn.Enabled := not False;
  FormatBtn.Enabled := not False;
  SaveBtn.Enabled := MMDSCaptureChannel1.CaptureLength > 0;
  MMDSCapture1.Close;
end;

procedure TForm1.SaveBtnClick(Sender: TObject);
begin
  if MMWaveSaveDialog1.Execute then
    MMDSCaptureChannel1.SaveToWaveFile(MMWaveSaveDialog1.FileName)
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
   Label1.Caption := IntToStr(MMDSCaptureChannel1.Position);
end;

end.
